<?php
$searchQuery = urlencode("硅pu球场一般多厚");
$bingImageSearchUrl = "https://cn.bing.com/images/search?q={$searchQuery}&form=HDRSC2&first=1";

// 使用 cURL 获取 HTML
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $bingImageSearchUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36');
$html = curl_exec($ch);
curl_close($ch);

if ($html === false) {
    die("无法获取 Bing 图片搜索结果");
}

// 提取 JSON 数据（Bing 的图片数据通常存储在 `var _model = ...` 中）
preg_match('/var _model =(\{.*?\});/s', $html, $matches);
if (!isset($matches[1])) {
    die("无法解析 Bing 图片数据");
}

$jsonData = json_decode($matches[1], true);
if (json_last_error() !== JSON_ERROR_NONE) {
    die("JSON 解析失败: " . json_last_error_msg());
}

// 获取第一张大图的 URL（通常是第一个结果的 `murl`）
if (isset($jsonData['images']['results'][0]['murl'])) {
    $originalImageUrl = $jsonData['images']['results'][0]['murl'];
    echo "原始大图 URL: " . $originalImageUrl;
} else {
    die("未找到大图 URL");
}