<?php
// 获取当前页面主题（这里通过URL参数'theme'获取，你可以根据需要修改）
$theme = isset($_GET['theme']) ? $_GET['theme'] : '塑胶跑道';

// 远程API URL（替换为你的实际API地址）
$api_url = 'https://cdn.paodao.wang:9925/photos/images.php?theme=' . urlencode($theme);

// 初始化cURL（PHP5.2兼容方式）
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
$response = curl_exec($ch);
curl_close($ch);

// 解码JSON响应（PHP5.2兼容方式，不使用json_last_error）
$image_list = json_decode($response, true);

// 检查是否成功获取图片列表
if ($image_list && is_array($image_list) && !empty($image_list)) {
    // 随机选择一张图片
    $random_index = array_rand($image_list);
    $random_image_url = $image_list[$random_index];
    
    // 输出图片URL（可以根据需要输出img标签）
    echo $random_image_url;
    // 或者输出完整的img标签： echo '<img src="'.htmlspecialchars($random_image_url).'" alt="'.htmlspecialchars($theme).'" />';
} else {
    // 错误处理：使用默认图片或显示错误信息
    echo 'default_image.jpg';
    // 或者： echo '无法获取主题"'.htmlspecialchars($theme).'"的图片';
}
?>